<?php

require 'vendor/autoload.php';

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

$token = "7457441807:AAFDwMcM34Utxy9RRNWvbTU_6RC4-Sxopb4";  // Your Telegram bot token
$chatId = null; // This will be set later when receiving updates

function ask_gpt($msg) {
    $client = new Client();
    $url = "https://us-central1-amor-ai.cloudfunctions.net/chatWithGPT";
    $payload = json_encode(["data" => ["messages" => [["role" => "user", "content" => $msg]]]]);
    
    try {
        $response = $client->post($url, [
            'headers' => [
                'User-Agent' => 'okhttp/5.0.0-alpha.2',
                'Accept-Encoding' => 'gzip',
                'Content-Type' => 'application/json; charset=utf-8',
            ],
            'body' => $payload,
        ]);
        
        $body = json_decode($response->getBody(), true);
        return $body['result']['choices'][0]['message']['content'];
        
    } catch (RequestException $e) {
        return "An error occurred while connecting to the server: " . $e->getMessage();
    } catch (Exception $e) {
        return "An error occurred while processing data from the server.";
    }
}

function send_message($chat_id, $text) {
    global $token; // Access the global token variable
    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
    ];
    file_get_contents($url . '?' . http_build_query($params));
}

// Handle incoming webhook updates
$update = json_decode(file_get_contents("php://input"), true);
$chatId = $update['message']['chat']['id'] ?? null;

if (isset($update['message'])) {
    // Check for '/start' command
    if ($update['message']['text'] === '/start') {
        $welcomeText = "Welcome! Click the button to start chatting with the AI.";
        send_message($chatId, $welcomeText);
        // Here you might implement a button (inline keyboard) to start chat
    } else {
        // Handle conversation
        if (strtolower($update['message']['text']) === 'end') {
            send_message($chatId, "The conversation has ended. Type /start to begin again.");
        } else {
            $response = ask_gpt($update['message']['text']);
            send_message($chatId, $response);
        }
    }
}
