<?php
// Include Guzzle HTTP client for API requests
require 'vendor/autoload.php';
use GuzzleHttp\Client;

// Set your Telegram Bot API token
$botToken = '6709085741:AAGH-VZNdHc0VAgfdnRKcLMW4ZG3UVpzB6Q';
$apiUrl = "https://api.telegram.org/bot$botToken/";

// Function to extract subdomains from a given domain
function extractSubdomains($domain) {
    $subdomains = [];

    // Use dns_get_record to fetch DNS records
    $dnsRecords = dns_get_record($domain, DNS_ANY);
    foreach ($dnsRecords as $record) {
        // Filter out subdomains that belong to the domain
        if (isset($record['host']) && strpos($record['host'], $domain) !== false && $record['host'] != $domain) {
            $subdomains[] = $record['host'];
        }
    }

    return array_unique($subdomains);
}

// Function to send messages to the user
function sendMessage($chatId, $message) {
    global $apiUrl;
    $url = $apiUrl . "sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message
    ];

    // Use file_get_contents to send the message
    file_get_contents($url . "?" . http_build_query($data));
}

// Get updates from the bot (Webhook setup)
$update = file_get_contents("php://input");
$updateArray = json_decode($update, true);

// Ensure the update contains a message
if (isset($updateArray['message'])) {
    $chatId = $updateArray['message']['chat']['id'];
    $message = $updateArray['message']['text'];

    // Check if the message is a valid domain
    if (filter_var($message, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME)) {
        // Extract subdomains from the given domain
        $subdomains = extractSubdomains($message);

        if (!empty($subdomains)) {
            // Format the response
            $response = "Subdomains found for $message:\n" . implode("\n", $subdomains);
        } else {
            // No subdomains found
            $response = "No subdomains found for $message.";
        }

        // Send the response back to the user
        sendMessage($chatId, $response);
    } else {
        // Invalid domain input
        sendMessage($chatId, "Please send a valid domain (e.g., example.com).");
    }
} else {
    // Debugging: Log if no message is found in the update
    file_put_contents("log.txt", "No message received: " . print_r($updateArray, true) . "\n", FILE_APPEND);
}
?>
