<?php

$botToken = "7916543699:AAEDFsMVSH5hBYFiBcQcpbRYpEMLpW-DLyM";
$apiUrl = "https://api.telegram.org/bot$botToken/";

$input = file_get_contents("php://input");
$update = json_decode($input, TRUE);

if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $text = $update["message"]["text"];

    if ($text == "/start") {
        sendMessage($chatId, "Welcome to the Theme Creator Bot! Use /createtheme to begin creating your theme. Credit: @noob_je");
    } elseif ($text == "/createtheme") {
        sendMessage($chatId, "Enter a background color (e.g., #ff5733) or an image URL:");
        file_put_contents("user_step_$chatId.json", json_encode(['step' => 1]));
    } elseif ($text == "/listthemes") {
        listThemes($chatId);
    } elseif (preg_match('/^\/deletetheme (.+)/', $text, $matches)) {
        deleteTheme($chatId, $matches[1]);
    } else {
        handleThemeCreation($chatId, $text);
    }
}

function handleThemeCreation($chatId, $text) {
    $userStepFile = "user_step_$chatId.json";
    if (!file_exists($userStepFile)) return;

    $userStep = json_decode(file_get_contents($userStepFile), true);

    switch ($userStep['step']) {
        case 1:
            $themeData = ['background' => $text];
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 2]));
            sendMessage($chatId, "Background set! Now enter text color (e.g., #ffffff):");
            break;

        case 2:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['text_color'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 3]));
            sendMessage($chatId, "Text color set! Enter font (e.g., Arial):");
            break;

        case 3:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['font'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 4]));
            sendMessage($chatId, "Font set! Enter font size for headings (e.g., 24px):");
            break;

        case 4:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['heading_size'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 5]));
            sendMessage($chatId, "Enter font size for body text (e.g., 16px):");
            break;

        case 5:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['body_size'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 6]));
            sendMessage($chatId, "Enter a title for your theme:");
            break;

        case 6:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['title'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 7]));
            sendMessage($chatId, "Enter a border style (e.g., solid, dashed):");
            break;

        case 7:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['border_style'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 8]));
            sendMessage($chatId, "Enter text alignment (left, center, right):");
            break;

        case 8:
            $themeData = json_decode(file_get_contents("theme_$chatId.json"), true);
            $themeData['text_align'] = $text;
            file_put_contents("theme_$chatId.json", json_encode($themeData));
            file_put_contents($userStepFile, json_encode(['step' => 0]));
            sendMessage($chatId, "Theme creation complete! Use /preview or /share. Credit: @noob_je");
            break;

        default:
            sendMessage($chatId, "Invalid step. Use /createtheme to restart.");
            break;
    }
}

function sendMessage($chatId, $text) {
    global $apiUrl;
    $url = $apiUrl . "sendMessage?chat_id=" . $chatId . "&text=" . urlencode($text);
    file_get_contents($url);
}

function listThemes($chatId) {
    $themeFiles = glob("themes/$chatId/*.json");
    if (empty($themeFiles)) {
        sendMessage($chatId, "No themes found. Use /createtheme to make one.");
    } else {
        $message = "Your saved themes:\n";
        foreach ($themeFiles as $file) {
            $themeName = basename($file, ".json");
            $message .= "- $themeName (Use /deletetheme $themeName to delete)\n";
        }
        sendMessage($chatId, $message);
    }
}

function deleteTheme($chatId, $themeName) {
    $themeFile = "themes/$chatId/$themeName.json";
    if (file_exists($themeFile)) {
        unlink($themeFile);
        sendMessage($chatId, "Theme '$themeName' deleted.");
    } else {
        sendMessage($chatId, "Theme '$themeName' not found.");
    }
}

function generateThemePreview($themeData) {
    $query = http_build_query([
        'bg' => $themeData['background'],
        'text' => $themeData['text_color'],
        'font' => $themeData['font'],
        'heading_size' => $themeData['heading_size'],
        'body_size' => $themeData['body_size'],
        'title' => $themeData['title'],
        'border_style' => $themeData['border_style'],
        'text_align' => $themeData['text_align'],
    ]);
    return "https://example.com/preview.php?$query";
}

function generateShareLink($themeData) {
    $shareId = uniqid();
    file_put_contents("themes/$shareId.json", json_encode($themeData));
    return "https://example.com/theme.php?id=$shareId";
}
?>
