<?php
// Twilio accounts configuration
$TWILIO_ACCOUNTS = [
    "1" => [
        "account_sid" => 'ACa1dbafefa180262d52b0fc0c3c944469',
        "auth_token" => '4c2991d2ee31abc8fa8f382bf5470a03',
        "phone_number" => '+19283252775',
    ],
    "2" => [
        "account_sid" => 'AC140b902e81366487e01c46c38a7524cb',
        "auth_token" => '53f30746c75776818fccd0dfa4e1de38',
        "phone_number" => '+14439918479',
    ]
];

// Telegram bot token
$TELEGRAM_BOT_TOKEN = '7215049525:AAHvu7fOvnpYcdLUEA9qOZVj114140G88fc';
$selected_account = "1"; // Default Twilio account

// Handle Telegram webhook
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $update = json_decode(file_get_contents("php://input"), true);

    if (isset($update["message"])) {
        $message = $update["message"];
        $chat_id = $message["chat"]["id"];
        $text = $message["text"];

        if (strpos($text, "/start") === 0) {
            sendTelegramMessage($chat_id, "👋 Welcome! Use /set_account 🔄 <1/2> to select the Twilio account.\n📲 Send /sms <Country Code> 🌎 <Phone Number> 📞 <Message> 📝 to send an SMS.");
        } elseif (strpos($text, "/set_account") === 0) {
            handleSetAccount($chat_id, $text);
        } elseif (strpos($text, "/sms") === 0) {
            handleSendSMS($chat_id, $text);
        }
    }
}

// Send message to Telegram
function sendTelegramMessage($chat_id, $text) {
    global $TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot$TELEGRAM_BOT_TOKEN/sendMessage";
    $data = ["chat_id" => $chat_id, "text" => $text];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
        ],
    ];

    $context  = stream_context_create($options);
    file_get_contents($url, false, $context);
}

// Handle setting the Twilio account
function handleSetAccount($chat_id, $text) {
    global $TWILIO_ACCOUNTS, $selected_account;
    $args = explode(" ", $text);

    if (count($args) < 2 || !isset($TWILIO_ACCOUNTS[$args[1]])) {
        sendTelegramMessage($chat_id, "Usage: /set_account 🔄 <1/2>");
        return;
    }

    $selected_account = $args[1];
    sendTelegramMessage($chat_id, "Twilio account $selected_account selected! 🎉");
}

// Handle sending SMS via Twilio
function handleSendSMS($chat_id, $text) {
    global $selected_account, $TWILIO_ACCOUNTS;
    $args = explode(" ", $text, 4);

    if (count($args) < 4) {
        sendTelegramMessage($chat_id, "Usage: /sms 🌎 <Country Code> 📞 <Phone Number> 📝 <Message>");
        return;
    }

    $country_code = $args[1];
    $phone_number = $args[2];
    $sms_message = $args[3];
    $full_phone_number = "+$country_code$phone_number";

    if (!isset($TWILIO_ACCOUNTS[$selected_account])) {
        sendTelegramMessage($chat_id, "Invalid Twilio account selected.");
        return;
    }

    $account_details = $TWILIO_ACCOUNTS[$selected_account];
    sendTwilioMessage($account_details['account_sid'], $account_details['auth_token'], $account_details['phone_number'], $full_phone_number, $sms_message, $chat_id);
}

// Send SMS using Twilio API without vendor
function sendTwilioMessage($sid, $token, $from, $to, $body, $chat_id) {
    $url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";
    $data = [
        'From' => $from,
        'To' => $to,
        'Body' => $body,
    ];

    $options = [
        'http' => [
            'header'  => "Authorization: Basic " . base64_encode("$sid:$token") . "\r\n" .
                         "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
        ],
    ];

    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);

    if ($result === FALSE) {
        sendTelegramMessage($chat_id, "⚠️ Error: Unable to send SMS. Check Twilio credentials and try again.");
    } else {
        sendTelegramMessage($chat_id, "📤 SMS sent to $to using account $selected_account! ✅");
    }
}
?>
