<?php
// Your Heroku API Key
define('HEROKU_API_KEY', 'HRKU-24f3a355-4d73-442e-86d0-2f5caf8e447e');

// Telegram Bot Token
define('BOT_TOKEN', '7847084978:AAEba2ZYSGmsM0Wm_DHRUbOKJpn65TOgxis');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

// Webhook handling
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
    exit;
}

// Get message and chat ID
$message = isset($update['message']) ? $update['message'] : "";
$chat_id = $message['chat']['id'];
$text = isset($message['text']) ? $message['text'] : "";

// Command processing
if ($text == '/start') {
    sendMessage($chat_id, "Welcome to Heroku Deployment Bot! Use the following command to deploy:
    - /deployapp app_name git_url
    ");
} elseif (preg_match('/^\/deployapp (.+) (.+)/', $text, $matches)) {
    $app_name = trim($matches[1]);
    $git_url = trim($matches[2]);
    deployHerokuApp($chat_id, $app_name, $git_url);
} else {
    sendMessage($chat_id, "Invalid command.");
}

// Function to send a message
function sendMessage($chat_id, $message) {
    file_get_contents(API_URL . "sendMessage?chat_id=$chat_id&text=" . urlencode($message));
}

// Function to deploy a Heroku app from GitHub repository
function deployHerokuApp($chat_id, $app_name, $git_url) {
    // Deploy the app using Heroku API
    $url = "https://api.heroku.com/apps/$app_name/builds";
    $data = json_encode([
        'source_blob' => [
            'url' => $git_url // The GitHub repository URL
        ]
    ]);
    
    $response = herokuApiRequest($url, 'POST', $data);

    if ($response) {
        $result = json_decode($response, true);
        if (isset($result['id'])) {
            sendMessage($chat_id, "Deployment initiated for '$app_name' from GitHub repository!");
        } else {
            sendMessage($chat_id, "Failed to initiate deployment. Check your app name and repository URL.");
        }
    } else {
        sendMessage($chat_id, "Failed to deploy the app. Please check your Heroku settings.");
    }
}

// Function to make Heroku API requests
function herokuApiRequest($url, $method = 'GET', $data = null) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer " . HEROKU_API_KEY,
        "Content-Type: application/json",
        "Accept: application/vnd.heroku+json; version=3"
    ]);

    if ($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}
