<?php
// Load environment variables
require 'vendor/autoload.php';
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Telegram Bot API token
$token = getenv('7897896059:AAExDBM9Y2E6Z4aJDcBy7-SWUgqCV_TBlxQ');

// Telegram Bot URL
$apiURL = "https://api.telegram.org/bot$token/";

// Handle incoming Telegram messages
$update = json_decode(file_get_contents("php://input"), TRUE);

if ($update) {
    $chatId = $update["message"]["chat"]["id"];
    $messageText = $update["message"]["text"];

    if (!$messageText) {
        error_log('Received empty message');
        exit();
    }

    // Start command response
    if (strtolower($messageText) === '/start') {
        sendPhoto($chatId, 'https://i.ibb.co/GFBGb5F/3d35af405aef.jpg', "🌼 Welcome to Instagram DownloadeR\nSend me an Instagram video or image link to download it.\n🦋 Join the update channel:", [
            [
                ['text' => 'Join Update Channel', 'url' => 'https://t.me/NOOBPrivate']
            ]
        ]);
        exit();
    }

    // Check if message contains a valid Instagram post URL
    if (strpos($messageText, 'instagram.com') !== false) {
        try {
            error_log("Received Instagram URL: $messageText");

            // Send processing sticker
            $stickerId = 'CAACAgQAAxkBAAEMzLJm483R53GzjAHmbr3ms3iOFSlTqAADFAAClt1hUHmPWNO7Sd_YNgQ';
            $stickerMessageId = sendSticker($chatId, $stickerId);

            // Extract direct URLs (both images and videos) from Instagram post
            $directUrls = extractInstagramDirectUrls($messageText);
            error_log('Direct URLs: ' . json_encode($directUrls));

            if (!isset($directUrls['url_list']) || count($directUrls['url_list']) === 0) {
                throw new Exception('No direct URLs found');
            }

            // Iterate through each URL and send media
            foreach ($directUrls['url_list'] as $url) {
                $mediaContent = file_get_contents($url);

                if (strpos($url, '.jpg') !== false || strpos($url, '.jpeg') !== false || strpos($url, '.png') !== false) {
                    sendPhoto($chatId, $mediaContent, 'Download from Instra Bot:', [
                        [
                            ['text' => 'Join Update Channel', 'url' => 'https://t.me/NOOBPrivate']
                        ]
                    ]);
                } else {
                    sendVideo($chatId, $mediaContent, [
                        [
                            ['text' => 'Join Update Channel', 'url' => 'https://t.me/NOOBPrivate']
                        ]
                    ]);
                }
            }

            // Delete the processing sticker message
            deleteMessage($chatId, $stickerMessageId);
        } catch (Exception $e) {
            error_log('Error processing media: ' . $e->getMessage());
            sendMessage($chatId, "We're currently experiencing technical issues, we'll resolve this as soon as possible. Thank you for your understanding!");
        }
    }
}

// Function to send a photo
function sendPhoto($chatId, $photo, $caption, $keyboard = []) {
    global $apiURL;

    $data = [
        'chat_id' => $chatId,
        'photo' => $photo,
        'caption' => $caption,
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ];

    file_get_contents($apiURL . "sendPhoto?" . http_build_query($data));
}

// Function to send a video
function sendVideo($chatId, $video, $keyboard = []) {
    global $apiURL;

    $data = [
        'chat_id' => $chatId,
        'video' => $video,
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ];

    file_get_contents($apiURL . "sendVideo?" . http_build_query($data));
}

// Function to send a sticker
function sendSticker($chatId, $stickerId) {
    global $apiURL;

    $data = [
        'chat_id' => $chatId,
        'sticker' => $stickerId
    ];

    $response = file_get_contents($apiURL . "sendSticker?" . http_build_query($data));
    return json_decode($response, true)['result']['message_id'];
}

// Function to delete a message
function deleteMessage($chatId, $messageId) {
    global $apiURL;

    $data = [
        'chat_id' => $chatId,
        'message_id' => $messageId
    ];

    file_get_contents($apiURL . "deleteMessage?" . http_build_query($data));
}

// Function to send a message
function sendMessage($chatId, $text) {
    global $apiURL;

    $data = [
        'chat_id' => $chatId,
        'text' => $text
    ];

    file_get_contents($apiURL . "sendMessage?" . http_build_query($data));
}

// Function to extract direct URLs from Instagram post
function extractInstagramDirectUrls($instagramUrl) {
    // Here you should call Instagram APIs or a scraping service to extract direct image/video URLs
    // This is a placeholder example for Instagram scraping
    // Use an Instagram scraper library or service like 'instagram-url-direct'

    return [
        'url_list' => [
            'https://example.com/sample_image.jpg',
            'https://example.com/sample_video.mp4'
        ]
    ];
}
?>
