<?php
// Telegram Bot Token
$TELEGRAM_BOT_TOKEN = '8022651374:AAFJtNcC21zx0g-5_sdyTwFUl3JuAUyJFE8';

// Webhook endpoint
function handleRequest() {
    // Check if the request method is POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo "Method Not Allowed";
        return;
    }

    // Get the incoming JSON payload from Telegram
    $input = file_get_contents('php://input');
    $body = json_decode($input, true);

    // Get chat ID and message text
    $chatId = $body['message']['chat']['id'] ?? null;
    $text = $body['message']['text'] ?? null;

    // Check if message data is valid
    if (!$chatId || !$text) {
        http_response_code(400);
        echo "Invalid data";
        return;
    }

    // If message contains TeraBox URL, process it
    if (strpos($text, 'terabox') !== false) {
        sendTelegramMessage($chatId, "Processing your request, please wait...");

        try {
            // Call the TeraBox API
            $teraboxApiUrl = 'https://terabox.mohanishx1.workers.dev/?url=' . urlencode($text);
            $teraboxResponse = file_get_contents($teraboxApiUrl);

            // Check if the API call was successful
            if ($teraboxResponse) {
                $responseHeaders = $http_response_header;
                $contentType = getHeaderValue($responseHeaders, 'Content-Type');

                // Send appropriate file type to Telegram
                if (strpos($contentType, 'image') !== false) {
                    uploadPhotoToTelegram($chatId, $teraboxResponse);
                } elseif (strpos($contentType, 'video') !== false) {
                    uploadVideoToTelegram($chatId, $teraboxResponse);
                } else {
                    uploadDocumentToTelegram($chatId, $teraboxResponse, $contentType);
                }

                sendTelegramMessage($chatId, "File uploaded successfully!");
            } else {
                sendTelegramMessage($chatId, "Failed to fetch the file from TeraBox. Status code: " . http_response_code());
            }
        } catch (Exception $e) {
            sendTelegramMessage($chatId, "An error occurred: " . $e->getMessage());
        }
    } else {
        // If no TeraBox link is found, send a prompt
        sendTelegramMessage($chatId, "🌟 ɪ ᴀᴍ ᴀ ᴛᴇʀᴀʙᴏx ᴅᴏᴡɴʟᴏᴀᴅᴇʀ ʙᴏᴛ.
sᴇɴᴅ ᴍᴇ ᴀɴʏ ᴛᴇʀᴀʙᴏx ʟɪɴᴋ ɪ ᴡɪʟʟ ᴅᴏᴡɴʟᴏᴀᴅ ᴡɪᴛʜɪɴ ғᴇᴡ sᴇᴄᴏɴᴅs
ᴀɴᴅ sᴇɴᴅ ɪᴛ ᴛᴏ ʏᴏᴜ 🌐

!!Dev @noob_je
!!Support @NOOBPrivate 
");
    }

    http_response_code(200);
    echo "OK";
}

// Function to send a message to Telegram
function sendTelegramMessage($chatId, $text) {
    global $TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
    ];

    sendPostRequest($url, $data);
}

// Function to upload a document to Telegram
function uploadDocumentToTelegram($chatId, $fileBuffer, $contentType) {
    global $TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendDocument";
    $file = createTempFile($fileBuffer, 'file.bin');

    $data = [
        'chat_id' => $chatId,
        'document' => new CURLFile($file, $contentType, 'file.bin'),
    ];

    sendPostRequest($url, $data);
    unlink($file); // Clean up temporary file
}

// Function to upload a photo to Telegram
function uploadPhotoToTelegram($chatId, $fileBuffer) {
    global $TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendPhoto";
    $file = createTempFile($fileBuffer, 'photo.jpg');

    $data = [
        'chat_id' => $chatId,
        'photo' => new CURLFile($file, 'image/jpeg', 'photo.jpg'),
    ];

    sendPostRequest($url, $data);
    unlink($file); // Clean up temporary file
}

// Function to upload a video to Telegram
function uploadVideoToTelegram($chatId, $fileBuffer) {
    global $TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$TELEGRAM_BOT_TOKEN}/sendVideo";
    $file = createTempFile($fileBuffer, 'video.mp4');

    $data = [
        'chat_id' => $chatId,
        'video' => new CURLFile($file, 'video/mp4', 'video.mp4'),
    ];

    sendPostRequest($url, $data);
    unlink($file); // Clean up temporary file
}

// Helper function to send POST request
function sendPostRequest($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

// Helper function to create a temporary file for uploads
function createTempFile($buffer, $filename) {
    $file = tempnam(sys_get_temp_dir(), 'telegram');
    file_put_contents($file, $buffer);
    return $file;
}

// Helper function to extract header values
function getHeaderValue($headers, $key) {
    foreach ($headers as $header) {
        if (stripos($header, $key) !== false) {
            return trim(explode(':', $header)[1]);
        }
    }
    return null;
}

// Handle the request
handleRequest();
?>
