<?php

// Telegram Bot Token
$telegramToken = getenv('7661085520:AAH-UCOkL6U3C-wd1sirF8eZukosvPfcTjU'); // Set your Telegram bot token as an environment variable
$telegramApiUrl = "https://api.telegram.org/bot$telegramToken";

// Base URL for temporary email service
$tempMailUrl = 'https://www.1secmail.com/api/v1/';

// User email storage
$userEmails = [];

// Function to send a message to the Telegram chat
function sendMessage($chatId, $text) {
    global $telegramApiUrl;
    $url = "$telegramApiUrl/sendMessage?chat_id=$chatId&text=" . urlencode($text);
    
    // Use file_get_contents to send the message
    $response = file_get_contents($url);
    if ($response === FALSE) {
        error_log("Error sending message to chat $chatId");
    }
}

// Function to generate a temporary email
function generateTempEmail($chatId) {
    global $tempMailUrl, $userEmails;

    $response = file_get_contents("$tempMailUrl?action=genRandomMailbox");
    if ($response === FALSE) {
        sendMessage($chatId, '😞 Sorry, I could not generate a temporary email at the moment. Please try again later! 🤖\n\n👤 Script by @l_abani');
        return;
    }

    $email = json_decode($response, true)[0];
    $userEmails[$chatId] = $email; // Store the user's temporary email
    sendMessage($chatId, "🎉 Your temporary email is: $email 🎉\nUse /check to see if you have any new messages!\n\n👤 Script by @l_abani");
}

// Function to check for new emails
function checkEmails($chatId) {
    global $tempMailUrl, $userEmails;

    if (!isset($userEmails[$chatId])) {
        sendMessage($chatId, '🚫 Please generate a temporary email first using /newemail.');
        return;
    }

    $email = $userEmails[$chatId];
    $login = explode('@', $email)[0];
    $domain = explode('@', $email)[1];
    $url = "$tempMailUrl?action=getMessages&login=$login&domain=$domain";
    
    $response = file_get_contents($url);
    if ($response === FALSE) {
        sendMessage($chatId, '😔 Sorry, I could not fetch your emails at the moment. Please check again later.\n\n👤 Script by @l_abani');
        return;
    }

    $messages = json_decode($response, true);
    if (empty($messages)) {
        sendMessage($chatId, '🧐 No new emails. You’re as popular as a potato at a salad bar! 🥔\n\n👤 Script by @l_abani');
    } else {
        foreach ($messages as $message) {
            sendMessage($chatId, "📬 From: {$message['from']}\n✉️ Subject: {$message['subject']}\n📝 Body: {$message['textSnippet']}\n\n🔗 Check your inbox for more details!\n\n👤 Script by @l_abani");
        }
    }
}

// Function to delete the temporary email
function deleteTempEmail($chatId) {
    global $userEmails;

    if (!isset($userEmails[$chatId])) {
        sendMessage($chatId, '🚫 You do not have a temporary email to delete. Use /newemail to create one.');
        return;
    }

    unset($userEmails[$chatId]); // Remove the email from storage
    sendMessage($chatId, '🗑️ Your temporary email has been deleted. Poof! Gone like my dreams of being a rockstar! 🎸\n\n👤 Script by @l_abani');
}

// Function to show help message
function showHelp($chatId) {
    $helpText = "
    📜 Available Commands:
    /start - Start the bot 🌟
    /newemail - Generate a new temporary email 🎉
    /check - Check for new emails 📬
    /delete - Delete your temporary email 🗑️
    /help - Show this help message ❓
    
    👤 Script by @l_abani
    ";
    sendMessage($chatId, $helpText);
}

// Handle incoming updates
$update = json_decode(file_get_contents('php://input'), true);

if (isset($update['message'])) {
    $chatId = $update['message']['chat']['id'];
    $message = trim($update['message']['text']);

    // Log the message for debugging
    error_log("Received message from $chatId: $message");

    switch (strtolower($message)) {
        case '/start':
            sendMessage($chatId, '👋 Welcome to the Temp Mail Bot! Use /newemail to get a temporary email and /check to check for new emails.\n\n👤 Script by @l_abani');
            break;
        case '/newemail':
            generateTempEmail($chatId);
            break;
        case '/check':
            checkEmails($chatId);
            break;
        case '/delete':
            deleteTempEmail($chatId);
            break;
        case '/help':
            showHelp($chatId);
            break;
        default:
            sendMessage($chatId, '🤖 I didn\'t understand that command. Type /help to see available commands!\n\n👤 Script by @l_abani');
            break;
    }
}
